<?php

// -----------------------------------------
// semplice
// admin/atts/post_settings.php
// -----------------------------------------

$post_settings = array(
	'meta' => array(
		'post_title' => array(
			'break' => '2',
			'title' => 'Title',
			'post_title' => array(
				'title'				=> 'Post title',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'input-text',
				'default'			=> '',
				'placeholder'		=> 'My Title',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type' 		=> 'meta',
			),
		),
		'project_type' => array(
			'break' => '2',
			'title' => 'Project Type',
			'class' => 'project-type',
			'project_type' => array(
				'title'				=> 'Project Type',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'input-text',
				'default'			=> '',
				'placeholder'		=> 'Corporate Design',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type' 		=> 'meta',
			),
		),
		'permalink' => array(
			'break' => '2',
			'title' => 'Permalink',
			'permalink' => array(
				'title'				=> 'Permalink',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'input-text',
				'data-ps-type' 		=> 'meta',
				'default'			=> '',
				'placeholder'		=> 'my-custom-url',
				'class'				=> 'ps-setting permalink-input admin-listen-handler',
				'data-handler'		=> 'postSettings',
			),
		),
		'categories' => array(
			'break' => '2',
			'title' => 'Categories',
			'categories' => array(
				'title'				=> 'Categories',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'categories',
				'data-ps-type' 		=> 'meta',
				'default'			=> '',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
			),
		),
		'navbar' => array(
			'break' => '2',
			'title' => 'Navigation Bar',
			'navbar_visibility' => array(
				'data-input-type' => 'switch',
				'switch-type'		=> 'twoway',
				'title'		 		=> 'Visibility',
				'size'		 		=> 'span2',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type' 		=> 'meta',
				'default' 	 		=> 'true',
				'switch-values' => array(
					'true'	 		=> 'Show',
					'false'  		=> 'Hide',
				),
			),
			'navbar' => array(
				'title'				=> 'Select Navigation',
				'size'				=> 'span2',
				'data-input-type'   => 'select-box',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type'		=> 'meta',
				'default'			=> 'default',
				'select-box-values' => array(
					'default'		=> 'Navigation 1',
					'default_new'		=> 'Navigation 2',
				),
			),
		),
		'footer' => array(
			'break' => '1',
			'title' => 'Footer',
			'footer' => array(
				'title'				 => 'Footer',
				'hide-title'		 => true,
				'size'				 => 'span2',
				'data-input-type'    => 'select-box',
				'class'			  	 => 'admin-listen-handler',
				'data-handler'		 => 'postSettings',
				'default'			 => '1',
				'data-ps-type'		 => 'meta',
				'select-box-values' => semplice_get_post_dropdown('footer'),
			),
		),
	),
	'thumbnail' => array(
		'thumbnail' => array(
			'break' 	 => '1',
			'title' 	 => 'Thumbnail',
			'width' => array(
				'title'				=> 'Thumbnail Width',
				'size'				=> 'span4',
				'data-input-type'   => 'select-box',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type'		=> 'thumbnail',
				'default'			=> '4',
				'select-box-values' => array(
					'1'				=> '1 Column',
					'2'				=> '2 Columns',
					'3'				=> '3 Columns',
					'4'				=> '4 Columns',
					'5'				=> '5 Columns',
					'6'				=> '6 Columns',
					'7'				=> '7 Columns',
					'8'				=> '8 Columns',
					'9'				=> '9 Columns',
					'10'			=> '10 Columns',
					'11'			=> '11 Columns',
					'12'			=> '12 Columns',
				),
			),
		),
		'pp-thumbnail' => array(
			'break' 	 => '1',
			'title' 	 => 'Project Panel Thumbnail',
			'project_panel' => array(
				'title'				=> 'Upload',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'admin-image-upload',
				'default'			=> '',
				'class'				=> 'admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type'		=> 'thumbnail',
				'data-upload'		=> 'ppThumbnail',
				'style-class'		=> 'pp-thumbnail-upload',
			),
		),
		'thumb-hover-visibility' => array(
			'break' 	 => '1',
			'title' 	 => 'Thumbnail Hover',
			'hover_visibility' => array(
				'data-input-type' => 'switch',
				'switch-type'				=> 'twoway',
				'title'		 				=> 'Status',
				'hide-title'				=> true,
				'size'		 				=> 'span4',
				'class'						=> 'ps-setting admin-listen-handler',
				'data-handler'				=> 'postSettings',
				'data-visibility-switch' 	=> true,
				'data-visibility-values' 	=> 'disabled,enabled',
				'data-visibility-prefix'	=> 'ov-hover',
				'data-ps-type' 				=> 'thumbnail',
				'default' 	 				=> 'disabled',
				'switch-values' => array(
					'disabled'		=> 'Disabled',
					'enabled'		=> 'Enabled',
				),
			),
		),
		'thumb-hover-background-color' => get_thumb_hover_options('background-color', $fonts),
		'thumb-hover-background-type' => get_thumb_hover_options('background-type', $fonts),
		'thumb-hover-background-image' => get_thumb_hover_options('background-image', $fonts),
		'thumb-hover-background-video' => get_thumb_hover_options('background-video', $fonts),
		'thumb-hover-title-category' => get_thumb_hover_options('title-category', $fonts),
		'thumb-hover-title' => get_thumb_hover_options('title', $fonts),	
		'thumb-hover-category' => get_thumb_hover_options('category', $fonts),
	),
	'seo' => array(
		'advanced' => array(
			'break' => '2, 1',
			'title' => 'Advanced',
			'description' => 'Here you can change the advanced SEO settings. You should not change these settings unless you know what you are doing. <br /><br />Leave the canonical url empty to use the permalink.',
			'_yoast_wpseo_meta-robots-noindex' => array(
				'title'				=> 'Meta robots index',
				'size'				=> 'span2',
				'data-input-type'   => 'select-box',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type'		=> 'seo',
				'default'			=> 0,
				'select-box-values' => array(
					0		=> 'Default',
					2		=> 'index',
					1		=> 'noindex',
				),
			),
			'_yoast_wpseo_meta-robots-nofollow' => array(
				'title'				=> 'Meta robots follow',
				'size'				=> 'span2',
				'data-input-type'   => 'select-box',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type'		=> 'seo',
				'default'			=> 0,
				'select-box-values' => array(
					0		=> 'follow',
					1		=> 'nofollow',
				),
			),
			'_yoast_wpseo_canonical' => array(
				'title'				=> 'Canonical URL',
				'hide-title'		=> true,
				'size'				=> 'span4',
				'data-input-type'	=> 'input-text',
				'default'			=> '',
				'placeholder'		=> 'Canonical URL',
				'class'				=> 'ps-setting admin-listen-handler',
				'data-handler'		=> 'postSettings',
				'data-ps-type' 		=> 'seo',
			),
		),
	),
);


?>