<?php

// -----------------------------------------
// semplice
// admin/atts/motions.php
// -----------------------------------------

$motions = array(

	// event
	'options' => array(
		'hide-title'		=> true,
		'break'				=> '1,1,2,2,2,2,1',
		'preview' => array(
			'title'			=> 'Preview',
			'button-title'	=> 'Preview Animation',
			'size'			=> 'span4',
			'data-input-type'    => 'button',
			'help'			=> 'Please note that the preview only plays the animation without the event being fired.<br /><br />Since "onScroll" animations are getting executed while scrolling you can only preview the animation itself.',
			'class' 		=> 'semplice-button motion-preview',
		),
		'event' => array(
			'title'			=> 'Event',
			'size'			=> 'span4',
			'data-input-type'    => 'select-box',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'on_load',
			'help'			=> 'Event that starts your animation:<br /><br /><b>On Load:</b><br />Once your content is visible in the browser viewport (at start or while scrolling) the animation starts.<br /><br /><b>On Sroll</b><br />These are scroll depended animations. They are getting rendered while you are scrolling your post.<br /><br /><b>On Click:</b><br /> If you click on your element.<br /><br /><b>On Mouseover:</b><br /> If you Mouseover your element.',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on_load,on_scroll,on_click,on_hover',
			'data-visibility-prefix'	=> 'ov-event',
			'data-visibility-special'	=> 'on_scroll',
			'select-box-values' => array(
				'on_load'		=> 'On Load',
				'on_scroll'		=> 'On Scroll',
				'on_click'		=> 'On Click',
				'on_hover'		=> 'On Mouseover',
			),
		),
		'trigger_hook' => array(
			'title'			=> 'Start Point',
			'help'			=> 'Your animation gets started once your content hits the start point (in this case vertical top, bottom or center) of your browser viewport while scrolling.',
			'size'			=> 'span2',
			'data-input-type'    => 'select-box',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'center',
			'style-class'	=> 'ov-event-on_scroll',
			'select-box-values' => array(
				'.5'		=> 'Center',
				'onLeave'	=> 'Top',
				'onEnter'	=> 'Bottom',
				'custom'	=> 'Custom',
			),
		),
		'trigger_hook_custom' => array(
			'title'			=> 'Custom SP',
			'help'			=> 'Enter your custom start point for the animation in percent. Example: 70 - This means your animation gets started once your content hits the 70% mark (vertically) of your browser viewport.',
			'size'			=> 'span2',
			'offset'		=> false,
			'data-input-type' 	=> 'range-slider',
			'default'		=> 50,
			'min'			=> 0,
			'max'			=> 100,
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'style-class'	=> 'ov-event-on_scroll',
			'data-range-slider' => 'motion',
		),
		'onscroll_duration' => array(
			'title'			=> 'Duration',
			'help'			=> 'Select the duration of your animation in percent. (Example: 50% means you need to scroll 50% of your browsers viewport height to finish the animation)',
			'size'			=> 'span2',
			'offset'		=> false,
			'data-input-type' 	=> 'range-slider',
			'default'		=> 50,
			'min'			=> 0,
			'max'			=> 5000,
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'style-class'	=> 'ov-event-on_scroll',
			'data-range-slider' => 'motion',
		),
		'onscroll_movement' => array(
			'title'			=> 'Movement',
			'help'			=> 'If you choose \'Sticky\' your content will stay sticky all the time while scrolling and animating at the start point position until the duration is over. Note that if you set the duration to 0, your content will stay sticky all the time.',
			'size'			=> 'span2',
			'data-input-type'    => 'switch',
			'switch-type'	=> 'twoway',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'normal',
			'style-class'	=> 'ov-event-on_scroll',
			'switch-values' => array(
				'normal'	=> 'Normal',
				'sticky'	=> 'sticky',
			),
		),
		'push_followers' => array(
			'title'			=> 'Push Followers',
			'help'			=> 'If \'enabled\' following elements will be "pushed" down for the duration of your \'sticky\' element. If \'disabled\' the sticky element will just scroll past them. Ignored, when duration is 0%.',
			'size'			=> 'span2',
			'data-input-type'   => 'switch',
			'switch-type'	=> 'twoway',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'disabled',
			'style-class'	=> 'ov-event-on_scroll',
			'switch-values' => array(
				'disabled'	=> 'Disabled',
				'enabled'	=> 'Enabled',
			),
		),
		'show_indicators' => array(
			'title'			=> 'Show Indicators',
			'help'			=> '\'Enabled\' will add an visual indicator for you to be able to see exactly when your animation is triggered. This is helpful to test and debug your \'on Scroll\' animation. Don\'t foget to disable it once your page / project is done.',
			'size'			=> 'span2',
			'data-input-type'   => 'switch',
			'switch-type'	=> 'twoway',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'disabled',
			'style-class'	=> 'ov-event-on_scroll',
			'switch-values' => array(
				'disabled'	=> 'Disabled',
				'enabled'	=> 'Enabled',
			),
		),
		'delay' => array(
			'title'			=> 'Delay (ms)',
			'size'			=> 'span2',
			'offset'		=> false,
			'data-input-type' 	=> 'range-slider',
			'default'		=> 0,
			'min'			=> 0,
			'max'			=> 50000,
			'help'			=> 'The delay is not considered in the preview.',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'style-class'	=> 'ov-event-on_load',
			'data-range-slider' => 'motion',
		),
		'duration' => array(
			'title'			=> 'Duration (ms)',
			'size'			=> 'span2',
			'offset'		=> false,
			'data-input-type' 	=> 'range-slider',
			'default'		=> 800,
			'min'			=> 0,
			'max'			=> 50000,
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'style-class'	=> 'ov-event-on_load',
			'data-range-slider' => 'motion',
		),
		'easing' => array(
			'title'			=> 'Easing',
			'size'			=> 'span4',
			'data-input-type'    => 'select-box',
			'class' 		=> 'editor-listen',
			'data-handler'	=> 'motion',
			'default'		=> 'ease',
			'style-class'	=> 'ov-event-on_load',
			'select-box-values' => $easings,
		),
	),
		/*
		'effects' => array(
			'title'			=> 'Effects',
			'size'			=> 'span4',
			'data-input-type' 	=> 'motion-effect',
			'class' 		=> 'listen-motion semplice-button white-button motion-effects',
		),
		*/
	'effect_switch_opacity' => array(
		'title'			=> 'Add Effects',
		'break'			=> '1',
		'class'			=> 'add-effects-heading',
		'motion_opacity' => array(
			'data-input-type' => 'onoff-switch',
			'style-class'=> 'first-switch',
			'title'		 => 'Opacity',
			'hide-title' => true,
			'size'		 => 'span4',
			'data-real-attr'	=> 'opacity',
			'class'      => 'motion-effect-switch',
			'default' 	 => 'off',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on,off',
			'data-visibility-prefix'	=> 'ov-motion-opacity',
			'switch-values' => array(
				'on'	 => 'On',
				'off'	 => 'Off',
			),
		),
	),
	'opacity' => array(
		'title'			=> 'Opacity',
		'hide-title'	=> true,
		'break'			=> '2',
		'class'			=> 'motion-sub',
		'motion_opacity_start' => array(
			'title'				=> 'Start',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-real-attr'	=> 'opacity',
			'data-motion-type'  => 'start',
			'data-divider'		=> 100,
			'default'			=> 50,
			'min'				=> 0,
			'max'				=> 100,
			'class' 			=> 'editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-opacity-on',
			'data-range-slider' => 'motionStyle',
		),
		'motion_opacity_end' => array(
			'title'				=> 'End',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-real-attr'	=> 'opacity',
			'data-motion-type'  => 'end',
			'data-divider' 		=> 100,
			'default'			=> 100,
			'min'				=> 0,
			'max'				=> 100,
			'class' 			=> 'editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-opacity-on',
			'data-range-slider' => 'motionStyle',
		),
	),
	'effect_switch_scale' => array(
		'title'			=> 'Add Effects',
		'hide-title'	=> true,
		'break'			=> '1',
		'motion_scale' => array(
			'data-input-type' => 'onoff-switch',
			'title'		 => 'Scale',
			'hide-title' => true,
			'size'		 => 'span4',
			'data-real-attr'	=> 'scale',
			'class'      => 'motion-effect-switch',
			'default' 	 => 'off',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on,off',
			'data-visibility-prefix'	=> 'ov-motion-scale',
			'switch-values' => array(
				'on'	 => 'On',
				'off'	 => 'Off',
			),
		),
	),
	'scale' => array(
		'title'			=> 'Scale',
		'hide-title'	=> true,
		'break'			=> '2',
		'class'			=> 'motion-sub',
		'motion_scale_start' => array(
			'title'				=> 'Start',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'start',
			'data-real-attr'	=> 'scale',
			'data-divider'		=> 100,
			'default'			=> 80,
			'min'				=> 0,
			'max'				=> 5000,
			'class' 			=> 'motion-transform-start editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-scale-on',
			'data-range-slider' => 'motionTransform',
		),
		'motion_scale_end' => array(
			'title'				=> 'End',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'end',
			'data-real-attr'	=> 'scale',
			'data-target'		=> '.content-block',
			'data-divider'	 	=> 100,
			'default'			=> 100,
			'min'				=> 0,
			'max'				=> 5000,
			'class' 			=> 'motion-transform-end editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-scale-on',
			'data-range-slider' => 'motionTransform',
		),
	),
	'effect_switch_move' => array(
		'title'			=> 'Add Effects',
		'hide-title'	=> true,
		'break'			=> '1',
		'motion_move' => array(
			'data-input-type' => 'onoff-switch',
			'title'		 => 'Move',
			'hide-title' => true,
			'size'		 => 'span4',
			'class'      => 'motion-effect-switch',
			'data-real-attr'	=> 'move',
			'default' 	 => 'off',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on,off',
			'data-visibility-prefix'	=> 'ov-motion-move',
			'switch-values' => array(
				'on'	 => 'On',
				'off'	 => 'Off',
			),
		),
	),
	'move' => array(
		'title'			=> 'Move',
		'hide-title'	=> true,
		'break'			=> '2',
		'class'			=> 'motion-sub',
		'motion_translateX_start' => array(
			'title'				=> 'X Axis',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'start',
			'data-real-attr'	=> 'translateX',
			'default'			=> 20,
			'min'				=> 0,
			'max'				=> 5000,
			'data-has-unit'		=> true,
			'data-negative'		=> true,
			'class' 			=> 'motion-transform-start editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-move-on',
			'data-range-slider' => 'motionTransform',
		),
		'motion_translateY_start' => array(
			'title'				=> 'Y Axis',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'start',
			'data-real-attr'	=> 'translateY',
			'data-target'		=> '.content-block',
			'default'			=> 20,
			'min'				=> 0,
			'max'				=> 5000,
			'data-has-unit'		=> true,
			'data-negative'		=> true,
			'class' 			=> 'motion-transform-start editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-move-on',
			'data-range-slider' => 'motionTransform',
		),
	),
	'effect_switch_rotate' => array(
		'title'			=> 'Add Effects',
		'hide-title'	=> true,
		'break'			=> '1',
		'motion_rotate' => array(
			'data-input-type' => 'onoff-switch',
			'title'		 => 'Rotate',
			'hide-title' => true,
			'size'		 => 'span4',
			'class'      => 'motion-effect-switch',
			'data-real-attr'	=> 'rotate',
			'default' 	 => 'off',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on,off',
			'data-visibility-prefix'	=> 'ov-motion-rotate',
			'switch-values' => array(
				'on'	 => 'On',
				'off'	 => 'Off',
			),
		),
	),
	'rotate' => array(
		'title'			=> 'Rotate',
		'hide-title'	=> true,
		'break'			=> '2',
		'class'			=> 'motion-sub',
		'motion_rotate_start' => array(
			'title'				=> 'Start',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'start',
			'data-real-attr'	=> 'rotate',
			'default'			=> 0,
			'min'				=> 0,
			'max'				=> 9999,
			'data-negative' 	=> true,
			'class' 			=> 'motion-transform-start editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-rotate-on',
			'data-range-slider' => 'motionTransform',
		),
		'motion_rotate_end' => array(
			'title'				=> 'End',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type' 	=> 'range-slider',
			'data-motion-type'  => 'end',
			'data-real-attr'	=> 'rotate',
			'data-target'		=> '.content-block',
			'default'			=> 0,
			'min'				=> 0,
			'max'				=> 9999,
			'data-negative' 	=> true,
			'class' 			=> 'motion-transform-end editor-listen',
			'data-handler'		=> 'motion',
			'style-class'		=> 'ov-motion-rotate-on',
			'data-range-slider' => 'motionTransform',
		),
	),
	'effect_switch_bgcolor' => array(
		'title'			=> 'Add Effects',
		'hide-title'	=> true,
		'break'			=> '1',
		'motion_background_color' => array(
			'data-input-type' => 'onoff-switch',
			'title'		 => 'Background Color',
			'hide-title' => true,
			'size'		 => 'span4',
			'class'      => 'motion-effect-switch',
			'data-real-attr'	=> 'background-color',
			'default' 	 => 'off',
			'data-visibility-switch' 	=> true,
			'data-visibility-values' 	=> 'on,off',
			'data-visibility-prefix'	=> 'ov-motion-bgcolor',
			'switch-values' => array(
				'on'	 => 'On',
				'off'	 => 'Off',
			),
		),
	),
	'background-color' => array(
		'title'			=> 'Background Color',
		'hide-title'	=> true,
		'break'			=> '2',
		'class'			=> 'motion-sub',
		'motion_background_color_end' => array(
			'title'				=> 'End',
			'size'				=> 'span2',
			'offset'			=> false,
			'data-input-type'	=> 'color',
			'data-motion-type'  => 'end',
			'data-real-attr'	=> 'background-color',
			'default'			=> 'transparent',
			'data-handler' 		=> 'colorPicker',
			'class'     		=> 'motion-effect-switch color-picker admin-listen-handler',
			'data-picker'		=> 'motionBgEnd',
			'style-class'		=> 'ov-motion-bgcolor-on',
			'data-range-slider' => 'motionStyle',
		),
	),
);

?>