<?php

// -----------------------------------------
// semplice
// admin/atts/modules/gallery.php
// -----------------------------------------

$gallery = array(
	'uploads' => array(
		'title' => 'Upload Images',
		'break' => '1',
		'data-hide-mobile' => true,
		'images' => array(
			'title'				=> 'Images',
			'hide-title'		=> true,
			'data-style-option' => true,
			'size'				=> 'span4',
			'data-input-type'	=> 'gallery-upload',
			'default'			=> '',
			'data-is-content' 	=> true,
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
		),
	),
	'Options' => array(
		'title' => 'Images',
		'break' => '2,2,2,2',
		'data-hide-mobile' => true,
		'width' => array(
			'data-input-type' => 'select-box',
			'title'		 	  => 'Width',
			'size'		 	  => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 	  => 'grid-width',
			'help'		 => '\'Original\' means that the image will not be scaled unless it is too big for the grid. If you choose \'Grid Width\', your image will always be scaled to match the grid width.',
			'select-box-values' => array(
				'grid-width'	 => 'Grid Width',
				'original'		 => 'Original',
			),
		),
		'cover_mode' => array(
			'data-input-type' => 'switch',
			'help' => 'If enabled your image gallery will be full width and full height like a cover.<br /><br />Only exception is that if your section has a custom height the gallery cover mode will use that height instead.<br /><br /><b>Important:</b><br/>To make this work please make sure that you only have 1 column in your section and that your section width is set to fluid with no gutters.',
			'switch-type'=> 'twoway',
			'title'		 => 'Cover Mode',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'disabled',
			'switch-values' => array(
				'enabled'	 => 'On',
				'disabled'	 => 'Off',
			),
		),
		'animation_status' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'Animation Status',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'enabled',
			'switch-values' => array(
				'enabled'		=> 'On',
				'disabled'	 	=> 'Off',
			),
		),
		'animation' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'Animation Type',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'sgs-crossfade',
			'switch-values' => array(
				'sgs-crossfade'	=> 'Fade',
				'sgs-slide'	 	=> 'Slide',
			),
		),
		'autoplay' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'AUtoplay',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'false',
			'switch-values' => array(
				'true'	 => 'On',
				'false'	 => 'Off',
			),
		),
		'timeout' => array(
			'data-input-type'	=> 'input-text',
			'title'		 	=> 'Timeout',
			'size'		 	=> 'span2',
			'placeholder'	=> '4000',
			'default'		=> '4000',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'help'			=> 'This is the timeout between images in milliseconds. Minimum is 600ms.',
		),
		'adaptive_height' => array(
			'data-input-type' => 'switch',
			'help'			  => 'If \'enabled\' the height of the gallery slider always adapts to the height of the active slide.',
			'switch-type'=> 'twoway',
			'title'		 => 'Adaptive Height',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'true',
			'switch-values' => array(
				'true'	 => 'On',
				'false'	 => 'Off',
			),
		),
		'infinite' => array(
			'data-input-type' => 'switch',
			'help'			  => 'If enabled, your gallery will automatically restart after the last slide.',
			'switch-type'=> 'twoway',
			'title'		 => 'Infinite Slider',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'false',
			'switch-values' => array(
				'false'	 => 'Disabled',
				'true'	 => 'Enabled',
			),
		),
	),
	'arrows' => array(
		'title' => 'Arrows',
		'break' => '2',
		'data-hide-mobile' => true,
		'arrows_color' => array(
			'title'				=> 'Color',
			'data-style-option' => true,
			'size'				=> 'span2',
			'data-input-type'	=> 'color',
			'default'			=> '#ffffff',
			'class'				=> 'color-picker',
		),
		'arrows_visibility' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'Visibility',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'true',
			'switch-values' => array(
				'true'	 => 'Show',
				'false'  => 'Hide',
			),
		),
	),
	'pagination' => array(
		'title' => 'Pagination',
		'break' => '2,1',
		'data-hide-mobile' => true,
		'pagination_color' => array(
			'title'				=> 'Color',
			'data-style-option' => true,
			'size'				=> 'span2',
			'data-input-type'	=> 'color',
			'default'			=> '#000000',
			'class'				=> 'color-picker',
		),
		'pagination_visibility' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'Visibility',
			'size'		 => 'span2',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'false',
			'switch-values' => array(
				'true'	 => 'Show',
				'false'  => 'Hide',
			),
		),
		'pagination_position' => array(
			'data-input-type' => 'switch',
			'switch-type'=> 'twoway',
			'title'		 => 'Position',
			'size'		 => 'span4',
			'class'      		=> 'editor-listen',
			'data-handler' 		=> 'save',
			'default' 	 => 'below',
			'switch-values' => array(
				'below'	 => 'Below Image',
				'above'  => 'Above Image',
			),
		),
	),
);

?>