<?php

// -----------------------------------------
// semplice
// admin/atts/customize/blog.php
// -----------------------------------------

$blog = array(
	'tabs' => array(
		'basic' => array(
			'blog-options' => array(
				'title' => 'General',
				'break'	=> '3,2,2',
				'blog_bg_color' => array(
					'title'			=> 'BG Color',
					'data-css-attribute' => 'background-color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '#content-holder',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_divider_color' => array(
					'title'			=> 'Divider',
					'data-css-attribute' => 'background-color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-divider',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_navbar' => array(
					'title'				=> 'Select Navigation',
					'size'				=> 'span2',
					'data-input-type'   => 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'default'			=> 'default',
					'select-box-values' => array(
						'default'		=> 'Navigation 1',
						'default_new'		=> 'Navigation 2',
					),
				),
				'blog_width' => array(
					'title'				=> 'Width',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'default'			=> '8',
					'select-box-values' => array(
						'6'				=> '6 Columns',
						'7'				=> '7 Columns',
						'8'				=> '8 Columns',
						'9'				=> '9 Columns',
						'10'			=> '10 Columns',
						'11'			=> '11 Columns',
						'12'			=> '12 Columns',
					),
				),
				'blog_alignment' => array(
					'data-input-type' 			=> 'switch',
					'switch-type'				=> 'twoway',
					'title'		 				=> 'Alignment',
					'size'		 				=> 'span2',
					'class'						=> 'admin-listen-handler',
					'data-handler'				=> 'blog',
					'default' 	 				=> 'center',
					'switch-values' => array(
						'center'  	=> 'Center',
						'left'	 	=> 'Left',
					),
				),
				'blog_footer' => array(
					'title'				=> 'Select Footer',
					'size'				=> 'span2',
					'data-input-type'   => 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'default'			=> 'default',
					'select-box-values' => array(
						'default'		=> 'Navigation 1',
						'default_new'	=> 'Navigation 2',
					),
				),
				'display_content' => array(
					'title'			=> 'Display Content',
					'size'			=> 'span2',
					'data-input-type' => 'select-box',
					'switch-type' 	=> 'twoway',
					'class'			=> 'admin-listen-handler',
					'default'		=> 'navbar',
					'data-handler'	=> 'blog',
					'select-box-values' => array(
						'navbar'   => 'After Navigation',
						'top'  => 'Straight on Top',
					),
				),
			),
			'head-meta-options' => array(
				'title' => 'Post Title Meta',
				'break'	=> '2,3',
				'blog_head_meta_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.post-heading p a, .post-heading p span',
					'select-box-values' => $fonts,
				),
				'blog_head_meta_font_size' => array(
					'title'				=> 'Font size',
					'size'				=> 'span2',
					'data-input-type' 	=> 'range-slider',
					'class'				=> 'admin-listen-handler',
					'data-handler'		=> 'blog',
					'data-css-attribute'=> 'font-size',
					'data-target'		=> '.post-heading p a, .post-heading p span',
					'data-has-unit'		=> true,
					'default'			=> 18,
					'min'				=> 0,
					'max'				=> 9999,
					'data-range-slider' => 'blog',
				),
				'blog_head_meta_alignment' => array(
					'title'				=> 'Alignment',
					'data-css-attribute'=> 'text-align',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.post-heading p',
					'default'			=> 'left',
					'select-box-values' => array(
						'left'	=> 'Left',
						'center'=> 'Center',
						'right' => 'Right',
					),
				),
				'blog_head_meta_color' => array(
					'title'			=> 'Link',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-heading p a, .post-heading p span',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_head_meta_mouseover_color' => array(
					'title'			=> 'Hover',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'title-options' => array(
				'title' => 'Post Title',
				'help'	=> 'To change the title font size, font family etc. please go to \'Customize -> Typography\'',
				'break'	=> '3',
				'blog_title_alignment' => array(
					'title'				=> 'Alignment',
					'data-css-attribute'=> 'text-align',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.post-heading h2',
					'default'			=> 'left',
					'select-box-values' => array(
						'left'	=> 'Left',
						'center'=> 'Center',
						'right' => 'Right',
					),
				),
				'blog_title_color' => array(
					'title'			=> 'Link',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-heading h2 a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_title_mouseover_color' => array(
					'title'			=> 'Hover',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'content-options' => array(
				'title' => 'Post Content',
				'break'	=> '3',
				'help'	=> 'To change the content font size, font family etc. please go to \'Customize -> Typography\'',
				'blog_text_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-content',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_link_color' => array(
					'title'			=> 'Link',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-content a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_mouseover_color' => array(
					'title'			=> 'Hover',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'meta-options' => array(
				'title' => 'Post Meta',
				'break'	=> '2,2,2',
				'blog_meta_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.post-meta p',
					'select-box-values' => $fonts,
				),
				'blog_meta_font_size' => array(
					'title'				=> 'Font size',
					'size'				=> 'span2',
					'data-input-type' 	=> 'range-slider',
					'class'				=> 'admin-listen-handler',
					'data-handler'		=> 'blog',
					'data-css-attribute'=> 'font-size',
					'data-target'		=> '.post-meta *',
					'data-has-unit'		=> true,
					'default'			=> 18,
					'min'				=> 0,
					'max'				=> 9999,
					'data-range-slider' => 'blog',
				),
				'blog_meta_alignment' => array(
					'title'				=> 'Alignment',
					'data-css-attribute'=> 'text-align',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.post-meta *',
					'default'			=> 'left',
					'select-box-values' => array(
						'left'	=> 'Left',
						'center'=> 'Center',
						'right' => 'Right',
					),
				),
				'blog_meta_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-meta',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_meta_link_color' => array(
					'title'			=> 'Link',
					'data-css-attribute' => 'color',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'data-target'	=> '.post-meta a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'blog_meta_mouseover_color' => array(
					'title'			=> 'Hover',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
		),
		'advanced' => array(
			'featured-options' => array(
				'title' => 'Featured Image',
				'break'	=> '2',
				'blog_featured_width' => array(
					'title'				=> 'Width',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-box',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'default'			=> '12',
					'select-box-values' => array(
						'6'				=> '6 Columns',
						'7'				=> '7 Columns',
						'8'				=> '8 Columns',
						'9'				=> '9 Columns',
						'10'			=> '10 Columns',
						'11'			=> '11 Columns',
						'12'			=> '12 Columns',
						'fullscreen'	=> 'Fullscreen',
					),
				),
				'blog_featured_preview' => array(
					'data-input-type' 			=> 'switch',
					'switch-type'				=> 'twoway',
					'title'		 				=> 'Preview Visibility',
					'size'		 				=> 'span2',
					'class'						=> 'admin-listen-handler',
					'data-handler'				=> 'blog',
					'default' 	 				=> 'visible',
					'switch-values' => array(
						'visible'	=> 'Visible',
						'hidden'  	=> 'Hidden',
					),
				),
			),
			'sr-options' => array(
				'title' => 'Scroll Reveal',
				'help'  => 'You can customize the \'Scroll Reveal\' options in \'Customize -> Transitions\'',
				'break'	=> '1',
				'blog_scroll_reveal' => array(
					'data-input-type' 	=> 'switch',
					'switch-type'		=> 'twoway',
					'title'		 		=> 'Status',
					'size'				=> 'span4',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'default'			=> 'enabled',
					'switch-values' => array(
						'enabled'	=> 'Enabled',
						'disabled'  => 'Disabled',
					),
				),
			),
			'visibility-options' => array(
				'title' => 'Visibility Options',
				'break'	=> '2',
				'blog_visibility_category' => array(
					'data-input-type' 			=> 'switch',
					'switch-type'				=> 'twoway',
					'title'		 				=> 'Meta Published',
					'size'		 				=> 'span2',
					'class'						=> 'admin-listen-handler',
					'data-handler'				=> 'blog',
					'default' 	 				=> 'visible',
					'data-target'				=> '.category-meta',
					'switch-values' => array(
						'visible'	=> 'Visible',
						'hidden'  	=> 'Hidden',
					),
				),
				'blog_visibility_tags' => array(
					'data-input-type' 			=> 'switch',
					'switch-type'				=> 'twoway',
					'title'		 				=> 'Meta Tags',
					'size'		 				=> 'span2',
					'class'						=> 'admin-listen-handler',
					'data-handler'				=> 'blog',
					'default' 	 				=> 'visible',
					'data-target'				=> '.tags-meta',
					'switch-values' => array(
						'visible'	=> 'Visible',
						'hidden'  	=> 'Hidden',
					),
				),
			),
			'share_options' => get_share_module_options($fonts, true),
		),
		'comments-options' => array(
			'comments-general' => array(
				'title' => 'General',
				'break'	=> '2',
				'comments_visibility' => array(
					'data-input-type' 			=> 'switch',
					'switch-type'				=> 'twoway',
					'title'		 				=> 'Visibility',
					'size'		 				=> 'span2',
					'class'						=> 'admin-listen-handler',
					'data-handler'				=> 'blog',
					'default' 	 				=> 'visible',
					'data-target'				=> '.admin-blog-container',
					'help'						=> 'If set to hidden, the entire comments section (including the comments linked above the title) will not be visible.',
					'switch-values' => array(
						'visible'	=> 'Visible',
						'hidden'  	=> 'Hidden',
					),
				),
				'comment_bg_color' => array(
					'title'			=> 'Background Color',
					'data-css-attribute' => 'background-color',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'data-target'	=> '#comments',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'title-options' => array(
				'title' => 'Title',
				'break'	=> '2',
				'comment_title_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.comments-title',
					'select-box-values' => $fonts,
					'help'				=> 'No live preview available.',
				),
				'comment_title_color' => array(
					'title'			=> 'Title Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comments-title',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'author-options' => array(
				'title' => 'Author',
				'break'	=> '3',
				'comment_author_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.comment-author cite',
					'select-box-values' => $fonts,
				),
				'comment_author_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment-author cite, .comment-author cite a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_author_mouseover_color' => array(
					'title'			=> 'Hover',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'date-options' => array(
				'title' => 'Date',
				'break'	=> '3',
				'comment_date_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.comment-meta a',
					'select-box-values' => $fonts,
				),
				'comment_date_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment-meta a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_date_mouseover_color' => array(
					'title'			=> 'Hover',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'content-options' => array(
				'title' => 'Comment',
				'break'	=> '3',
				'comment_content_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.comment p',
					'select-box-values' => $fonts,
					'help'				=> 'No live preview available.',
				),
				'comment_content_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment p',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_content_divider_color' => array(
					'title'			=> 'Divider',
					'data-css-attribute' => 'border-color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment, .comment .depth-2, .comment .depth-3',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'reply-button-options' => array(
				'title' => 'Reply Button',
				'break'	=> '3',
				'comment_reply_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '.comment-reply-link, #cancel-comment-reply-link',
					'select-box-values' => $fonts,
				),
				'comment_reply_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment-reply-link, #cancel-comment-reply-link',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_reply_border_color' => array(
					'title'			=> 'Border',
					'data-css-attribute' => 'border-color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '.comment-reply-link, #cancel-comment-reply-link',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'respond-options' => array(
				'title' => 'Respond Title',
				'break'	=> '2',
				'comment_respond_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '#reply-title, #reply-title a',
					'select-box-values' => $fonts,
				),
				'comment_respond_color' => array(
					'title'			=> 'Title Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span2',
					'data-input-type'	=> 'color',
					'data-target'	=> '#reply-title, #reply-title a',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
			'form-options' => array(
				'title' => 'Form Options',
				'break'	=> '1,3',
				'comment_form_bg_color' => array(
					'title'			=> 'Background Color',
					'data-css-attribute' => 'background-color',
					'size'			=> 'span4',
					'data-input-type'	=> 'color',
					'data-target'	=> '#commentform input, #commentform submit, #commentform textarea',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_form_font_family' => array(
					'title'				=> 'Font Family',
					'size'				=> 'span2',
					'data-input-type'	=> 'select-fonts',
					'class'				=> 'admin-listen-handler',
					'data-handler'  	=> 'blog',
					'data-target'		=> '#commentform input, #commentform submit, #commentform textarea',
					'select-box-values' => $fonts,
				),
				'comment_form_color' => array(
					'title'			=> 'Color',
					'data-css-attribute' => 'color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '#commentform input, #commentform submit, #commentform textarea, ::-webkit-input-placeholder',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
				'comment_form_border_color' => array(
					'title'			=> 'Border',
					'data-css-attribute' => 'border-color',
					'size'			=> 'span1',
					'data-input-type'	=> 'color',
					'data-target'	=> '#commentform input, #commentform submit, #commentform textarea',
					'default'		=> 'transparent',
					'class'			=> 'color-picker admin-listen-handler',
					'data-handler'  => 'colorPicker',
					'data-has-unit'	=> false,
					'data-picker'   => 'blog',
				),
			),
		),
	),
);